<?php

declare(strict_types=1);

namespace Drupal\comment_tracker\Entity;

use Drupal\comment_tracker\CommentTrackerInterface;
use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityChangedTrait;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Provides the 'comment_tracker' Entity.
 *
 * @package Drupal\comment_tracker\Entity
 *
 * @ContentEntityType(
 *   id = "comment_tracker",
 *   label = @Translation("Comment tracker"),
 *   handlers = {
 *     "views_data" = "Drupal\views\EntityViewsData"
 *   },
 *   base_table = "comment_tracker",
 *   fieldable = FALSE,
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid"
 *   }
 * )
 */
final class CommentTracker extends ContentEntityBase implements CommentTrackerInterface {

  use EntityChangedTrait;

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {

    $fields = parent::baseFieldDefinitions($entity_type);

    // The comment that was read.
    $fields['comment_id'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Comment'))
      ->setSetting('target_type', 'comment')
      ->setRequired(TRUE);

    // The comment that was read.
    $fields['viewer_uid'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Viewer ID'))
      ->setSetting('target_type', 'user')
      ->setRequired(TRUE);  

    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Authored on'))
      ->setDescription(t('The time that the comment tracker was created.'));
      
    $fields['changed'] = BaseFieldDefinition::create('changed')
      ->setLabel(t('Changed'));

    return $fields;
  
  }

}
