<?php

namespace Drupal\commerce_admin_app\Plugin\rest\resource;

use Drupal\rest\ModifiedResourceResponse;
use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;
use Drupal\commerce_admin_app\Service\CommerceAnalyticsService;

/**
 * Provides a resource to get view modes by entity and bundle.
 *
 * @RestResource(
 *   id = "rest_RestAnalyticsOps",
 *   label = @Translation("Rest Analytics details"),
 *   uri_paths = {
 *     "create" = "/rest/commerce-admin/analytics/data",
 *     "https://www.drupal.org/link-relations/create" = "/rest/dncommerce/analytics/data"
 *   }
 * )
 */
class RestAnalyticsOps extends ResourceBase {
  /**
   * The commerce order service.
   *
   * @var \Drupal\commerce_admin_app\Service\CommerceAnalyticsService
   */
  protected $analyticsService;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->getParameter('serializer.formats'),
      $container->get('logger.factory')->get('rest'),
      $container->get('commerce_admin_app.commerce_analytics')
    );
  }

  /**
   * Constructs a new RestOrdersOps object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param array $serializer_formats
   *   The available serializer formats.
   * @param \Psr\Log\LoggerInterface $logger
   *   The logger service.
   * @param \Drupal\commerce_admin_app\Service\CommerceAnalyticsService $analytics_service
   *   The commerce analytics service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, array $serializer_formats, $logger, CommerceAnalyticsService $analytics_service) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $serializer_formats, $logger);
    $this->analyticsService = $analytics_service;
  }

  /**
   * Responds to POST requests.
   *
   * @return \Drupal\rest\ResourceResponse
   *   The HTTP response object.
   *
   * @throws \Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException
   *   If required data is missing or invalid.
   */
  public function post($data) {
    if (!isset($data['ops']) || empty($data['ops'])) {
      throw new UnprocessableEntityHttpException('Please provide ops value');
    }

    if ($data["ops"] == "all") {
       $range_type = $data["range_type"];
       $custom_start_date = $data["custom_start_date"];
       $custom_end_date = $data["custom_end_date"];
       

      $result_arr = [
        'message' => '',
        'status' => 'false',
        'ops' => $data["ops"],
        'total_data' => [
            'total_sales' => $this->analyticsService->getTotalSales($range_type,$custom_start_date,$custom_end_date),
          'average_sales' => $this->analyticsService->getAverageDailySales($range_type,$custom_start_date,$custom_end_date),
          'order_chart_data' => $this->analyticsService->getOrderChartData($range_type,$custom_start_date,$custom_end_date),
          'trending_items' => $this->analyticsService->getTrendingItems($range_type,$custom_start_date,$custom_end_date),
        ],
      ];

      $response = new ResourceResponse($result_arr);
      $response->addCacheableDependency($result_arr);
      return $response;
    }
  }
}
