<?php
namespace Drupal\commerce_admin_app\Plugin\rest\resource;

use Drupal\rest\ModifiedResourceResponse;
use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;
use Drupal\profile\Entity\ProfileType;
use Drupal\profile\Entity\Profile;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;
use CommerceGuys\Addressing\Country\CountryRepository;
use CommerceGuys\Addressing\Subdivision\SubdivisionRepository;


/**
 * Provides a resource to get view modes by entity and bundle.
 *
 * @RestResource(
 *   id = "rest_RestDashboardops",
 *   label = @Translation("Rest Dashboard details"),
 *   uri_paths = {
 *	  
 *     "create" = "/rest/commerce-admin/dashboard/data",
 *     "https://www.drupal.org/link-relations/create" = "/rest/dncommerce/dashboard/data"
 *   }
 * )
 */

 class RestDashboardops extends ResourceBase {

    /**
   * Responds to POST requests.
   *
   * @return \Drupal\rest\ResourceResponse
   *   The HTTP response object.
   *
   * @throws \Symfony\Component\HttpKernel\Exception\HttpException
   *   Throws exception expected.
   */
  public function post($data) {

    //===============request body text
    /*
    {
    "ops": "all",
    "time_range":"monthly",
    "user_id":"3",
    "set_default":"true",
    "address": {
      "given_Name": "shanap",
      "family_name":"ParaKur",
      "country_code":"91",
      "locality":"India",
      "administrative_area":"Kondotty",
      "postal_code": "673641",
      "address_line1":"fhhkhhfelsd slhlhlh",
      "address_line2":"fhhkhhflsd slhlhlh"
      
      }
    }
    */
    //===============request body text
     
    $result_arr =  ['message' => '','status'=>'false','ops'=>$data["ops"]];  
    

    
    
    if (!(isset($data['ops'])) || empty($data['ops']) ) {
      throw new UnprocessableEntityHttpException('Please provide ops value');

    }

    if($data["ops"] == "all"){{

        $result_arr['total_data'] = $this->get_commerce_statistics();
        
        $response = new ResourceResponse($result_arr);
        $response->addCacheableDependency($result_arr);
        return $response;



    }



  }//=====post data check


 }

 /*===========count k in number=======*/
 function thousandsCurrencyFormat($num) {

    if($num>1000) {
  
          $x = round($num);
          $x_number_format = number_format($x);
          $x_array = explode(',', $x_number_format);
          $x_parts = array('k', 'm', 'b', 't');
          $x_count_parts = count($x_array) - 1;
          $x_display = $x;
          $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
          $x_display .= $x_parts[$x_count_parts - 1];
  
          return $x_display;
  
    }
  
    return $num;
  }

/**
 * Get comprehensive commerce statistics including orders and customers.
 *
 * @return array
 *   Array containing commerce statistics.
 */
function get_commerce_statistics() {
  try {
    // Get total products
    $total_products = \Drupal::entityQuery('commerce_product')
      ->accessCheck(TRUE)
      ->count()
      ->execute();
      $total_products =$this->thousandsCurrencyFormat($total_products); 

    // Get total completed orders
    $total_orders = \Drupal::entityQuery('commerce_order')
      ->accessCheck(TRUE)
      ->condition('state', 'completed')
      ->count()
      ->execute();
      $total_orders =   $this->thousandsCurrencyFormat($total_orders); 

    // Get total customers (unique users who have placed orders)
    $customer_query = \Drupal::database()->select('commerce_order', 'co')
      ->fields('co', ['uid'])
      ->condition('state', 'completed')
      ->distinct();
    $total_customers = $customer_query->countQuery()->execute()->fetchField();
    $total_customers =$this->thousandsCurrencyFormat($total_customers); 
    // Get total sales value from completed orders
    $query = \Drupal::entityQuery('commerce_order')
      ->accessCheck(TRUE)
      ->condition('state', 'completed')
      ->execute();
    
    $total_sales = 0;
    $orders_by_status = [
      'draft' => 0,
      'completed' => 0,
      'canceled' => 0,
      'processing' => 0,
    ];

    if (!empty($query)) {
      $orders = \Drupal::entityTypeManager()
        ->getStorage('commerce_order')
        ->loadMultiple($query);
      
      foreach ($orders as $order) {
        $total_sales += $order->getTotalPrice()->getNumber();
      }
      
      $total_sales =   $this->thousandsCurrencyFormat($total_sales); 

      // Get orders by status
      /*foreach (['draft', 'completed', 'canceled', 'processing'] as $status) {
        $orders_by_status[$status] = \Drupal::entityQuery('commerce_order')
          ->accessCheck(TRUE)
          ->condition('state', $status)
          ->count()
          ->execute();
      }*/
    }

    // Get customer statistics
   // $customer_stats = get_customer_statistics();

    return [
      'total_products' => $total_products,
      'total_orders' => $total_orders,
      'total_customers' => $total_customers,
      'total_sales' => $total_sales,
      'day_graph_data' => $this->getSalesDataForChart('daily',7),
      'weekly_graph_data' => $this->getSalesDataForChart('weekly',7),
      'monthly_graph_data' => $this->getSalesDataForChart('monthly',7)
      /*'average_order_value' => $total_orders > 0 ? ($total_sales / $total_orders) : 0,
      'orders_by_status' => $orders_by_status,
      'customer_stats' => $customer_stats,*/
    ];
  }
  catch (\Exception $e) {
    \Drupal::logger('commerce_statistics')->error('Error getting commerce statistics: @message', ['@message' => $e->getMessage()]);
    return [
      'total_products' => 0,
      'total_orders' => 0,
      'total_customers' => 0,
      'total_sales' => 0,
      /*'average_order_value' => 0,
      'orders_by_status' => [],
      'customer_stats' => [],*/
    ];
  }
}

/**
 * Get daily total sales from completed orders.
 *
 * @param string $date
 *   Date in Y-m-d format. Defaults to current date.
 * 
 * @return float
 *   Total sales amount for the specified date.
 */
function getDailySales($date = NULL) {
    if (!$date) {
      $date = date('Y-m-d');
    }
    
    $start = strtotime($date . ' 00:00:00');
    $end = strtotime($date . ' 23:59:59');
    
    $query = \Drupal::entityQuery('commerce_order')
      ->accessCheck(TRUE)
      ->condition('state', 'completed')
      ->condition('completed', $start, '>=')
      ->condition('completed', $end, '<=')
      ->execute();
      
    $total_sales = 0;
    
    if (!empty($query)) {
      $orders = \Drupal::entityTypeManager()
        ->getStorage('commerce_order')
        ->loadMultiple($query);
      
      foreach ($orders as $order) {
        $total_sales += $order->getTotalPrice()->getNumber();
      }
    }
    
    return $total_sales;
  }
  
  /**
   * Get weekly total sales from completed orders.
   *
   * @param string $start_date
   *   Start date in Y-m-d format. Defaults to start of current week.
   * 
   * @return float
   *   Total sales amount for the specified week.
   */
  function getWeeklySales($start_date = NULL) {
    if (!$start_date) {
      // Get start of current week (Monday)
      $start_date = date('Y-m-d', strtotime('monday this week'));
    }
    
    $end_date = date('Y-m-d', strtotime($start_date . ' +6 days'));
    
    $start = strtotime($start_date . ' 00:00:00');
    $end = strtotime($end_date . ' 23:59:59');
    
    $query = \Drupal::entityQuery('commerce_order')
      ->accessCheck(TRUE)
      ->condition('state', 'completed')
      ->condition('completed', $start, '>=')
      ->condition('completed', $end, '<=')
      ->execute();
      
    $total_sales = 0;
    
    if (!empty($query)) {
      $orders = \Drupal::entityTypeManager()
        ->getStorage('commerce_order')
        ->loadMultiple($query);
      
      foreach ($orders as $order) {
        $total_sales += $order->getTotalPrice()->getNumber();
      }
    }
    
    return $total_sales;
  }
  
  /**
   * Get monthly total sales from completed orders.
   *
   * @param string $month
   *   Month in Y-m format. Defaults to current month.
   * 
   * @return float
   *   Total sales amount for the specified month.
   */
  function getMonthlySales($month = NULL) {
    if (!$month) {
      $month = date('Y-m');
    }
    
    $start = strtotime($month . '-01 00:00:00');
    $end = strtotime($month . '-' . date('t', $start) . ' 23:59:59');
    
    $query = \Drupal::entityQuery('commerce_order')
      ->accessCheck(TRUE)
      ->condition('state', 'completed')
      ->condition('completed', $start, '>=')
      ->condition('completed', $end, '<=')
      ->execute();
      
    $total_sales = 0;
    
    if (!empty($query)) {
      $orders = \Drupal::entityTypeManager()
        ->getStorage('commerce_order')
        ->loadMultiple($query);
      
      foreach ($orders as $order) {
        $total_sales += $order->getTotalPrice()->getNumber();
      }
    }
    
    return $total_sales;
  }
  
  /**
   * Get sales data for chart display.
   *
   * @param string $period
   *   Period type: 'daily', 'weekly', or 'monthly'.
   * @param int $limit
   *   Number of periods to return.
   * 
   * @return array
   *   Array of sales data for the specified period.
   */
  function getSalesDataForChart($period = 'monthly', $limit = 7) {
    $sales_data = [];
    
    switch ($period) {
        case 'daily':
          for ($i = $limit - 1; $i >= 0; $i--) {
            $date = date('Y-m-d', strtotime("-$i days"));
            $sales_data[] = [
              'day' => date('D', strtotime($date)), // Returns abbreviated day name (Mon, Tue, etc.)
              'revenue' => $this->getDailySales($date)
            ];
          }
          break;
          
        case 'weekly':
          for ($i = $limit - 1; $i >= 0; $i--) {
            $start_date = date('Y-m-d', strtotime("-$i weeks monday"));
            $end_date = date('Y-m-d', strtotime($start_date . ' +6 days'));
            $week_label = date('M d', strtotime($start_date)) . ' - ' . date('M d', strtotime($end_date));
            $sales_data[] = [
              'day' => $week_label, // Returns format like "Dec 18 - Dec 24"
              'revenue' => $this->getWeeklySales($start_date)
            ];
          }
          break;
          
        case 'monthly':
          for ($i = $limit - 1; $i >= 0; $i--) {
            $month = date('Y-m', strtotime("-$i months"));
            $sales_data[] = [
              'day' => date('M Y', strtotime($month)), // Returns format like "Dec 2024"
              'revenue' => $this->getMonthlySales($month)
            ];
          }
          break;
      }
    
    return $sales_data;
  }

/**
 * Get detailed customer statistics.
 *
 * @return array
 *   Array containing customer statistics.
 */
/*function get_customer_statistics() {
  try {
    $stats = [];
    
    // Get customers with completed orders
    $query = \Drupal::database()->select('commerce_order', 'co');
    $query->join('users_field_data', 'u', 'co.uid = u.uid');
    $query->fields('co', ['uid'])
      ->fields('u', ['name', 'mail'])
      ->condition('co.state', 'completed')
      ->groupBy('co.uid')
      ->groupBy('u.name')
      ->groupBy('u.mail');
    $query->addExpression('COUNT(order_id)', 'order_count');
    $query->addExpression('MAX(completed)', 'last_order_date');
    
    $results = $query->execute();
    
    foreach ($results as $record) {
      // Get total spent for this customer
      $total_spent = \Drupal::database()->select('commerce_order', 'co')
        ->fields('co', ['total_price__number'])
        ->condition('uid', $record->uid)
        ->condition('state', 'completed')
        ->execute()
        ->fetchAll();
        
      $customer_total = 0;
      foreach ($total_spent as $amount) {
        $customer_total += $amount->total_price__number;
      }
      
      $stats[] = [
        'uid' => $record->uid,
        'name' => $record->name,
        'email' => $record->mail,
        'order_count' => $record->order_count,
        'total_spent' => $customer_total,
        'last_order' => $record->last_order_date,
        'average_order_value' => $record->order_count > 0 ? 
          ($customer_total / $record->order_count) : 0,
      ];
    }
    
    return $stats;
  }
  catch (\Exception $e) {
    \Drupal::logger('commerce_statistics')->error('Error getting customer statistics: @message', ['@message' => $e->getMessage()]);
    return [];
  }
}*/

/**
 * Get order fulfillment statistics.
 *
 * @param string $start_date
 *   Start date in Y-m-d format.
 * @param string $end_date
 *   End date in Y-m-d format.
 * 
 * @return array
 *   Array containing order fulfillment statistics.
 */
/*function get_order_fulfillment_stats($start_date = NULL, $end_date = NULL) {
  try {
    $query = \Drupal::entityQuery('commerce_order')
      ->accessCheck(TRUE);
      
    if ($start_date) {
      $query->condition('created', strtotime($start_date), '>=');
    }
    if ($end_date) {
      $query->condition('created', strtotime($end_date), '<=');
    }
    
    $order_ids = $query->execute();
    
    $stats = [
      'total_orders' => count($order_ids),
      'fulfillment_status' => [
        'pending' => 0,
        'processing' => 0,
        'shipped' => 0,
        'delivered' => 0,
      ],
      'processing_time' => [
        'average' => 0,
        'max' => 0,
        'min' => 0,
      ],
    ];
    
    if (!empty($order_ids)) {
      $orders = \Drupal::entityTypeManager()
        ->getStorage('commerce_order')
        ->loadMultiple($order_ids);
        
      $processing_times = [];
      
      foreach ($orders as $order) {
        // Count fulfillment statuses
        if ($order->hasField('field_fulfillment_status')) {
          $status = $order->field_fulfillment_status->value;
          if (isset($stats['fulfillment_status'][$status])) {
            $stats['fulfillment_status'][$status]++;
          }
        }
        
        // Calculate processing times for completed orders
        if ($order->getState()->getId() === 'completed' && 
            $order->getCompletedTime() && $order->getCreatedTime()) {
          $processing_time = $order->getCompletedTime() - $order->getCreatedTime();
          $processing_times[] = $processing_time;
        }
      }
      
      // Calculate processing time statistics
      if (!empty($processing_times)) {
        $stats['processing_time'] = [
          'average' => array_sum($processing_times) / count($processing_times),
          'max' => max($processing_times),
          'min' => min($processing_times),
        ];
      }
    }
    
    return $stats;
  }
  catch (\Exception $e) {
    \Drupal::logger('commerce_statistics')->error('Error getting order fulfillment statistics: @message', ['@message' => $e->getMessage()]);
    return [];
  }
}*/


}