<?php

namespace Drupal\commerce_admin_app\Plugin\rest\resource;

use Drupal\rest\ModifiedResourceResponse;
use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;
use Drupal\commerce_admin_app\Service\CommerceOrderService;

/**
 * Provides a resource to get view modes by entity and bundle.
 *
 * @RestResource(
 *   id = "rest_RestOrdersdops",
 *   label = @Translation("Rest Order details"),
 *   uri_paths = {
 *     "create" = "/rest/commerce-admin/orders/data",
 *     "https://www.drupal.org/link-relations/create" = "/rest/dncommerce/orders/data"
 *   }
 * )
 */
class RestOrdersOps extends ResourceBase {
  /**
   * The commerce order service.
   *
   * @var \Drupal\commerce_admin_app\Service\CommerceOrderService
   */
  protected $orderService;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->getParameter('serializer.formats'),
      $container->get('logger.factory')->get('rest'),
      $container->get('commerce_admin_app.commerce_order_service')
    );
  }

  /**
   * Constructs a new RestOrdersOps object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param array $serializer_formats
   *   The available serializer formats.
   * @param \Psr\Log\LoggerInterface $logger
   *   The logger service.
   * @param \Drupal\commerce_admin_app\Service\CommerceOrderService $order_service
   *   The commerce order service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, array $serializer_formats, $logger, CommerceOrderService $order_service) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $serializer_formats, $logger);
    $this->orderService = $order_service;
  }

  /**
   * Responds to POST requests.
   *
   * @return \Drupal\rest\ResourceResponse
   *   The HTTP response object.
   *
   * @throws \Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException
   *   If required data is missing or invalid.
   */
  public function post($data) {
    if (!isset($data['ops']) || empty($data['ops'])) {
      throw new UnprocessableEntityHttpException('Please provide ops value');
    }

    if ($data["ops"] == "all") {
       $time_range = $data["time_range"];
      $result_arr = [
        'message' => '',
        'status' => 'false',
        'ops' => $data["ops"],
        'total_data' => [
          'day_order_data' => $this->orderService->getOrderData('Today'),
          'weekly_order_data' => $this->orderService->getOrderData('Weekly'),
          'monthly_order_data' => $this->orderService->getOrderData('Monthly'),
        ],
      ];

      $response = new ResourceResponse($result_arr);
      $response->addCacheableDependency($result_arr);
      return $response;
    }
  }
}
