# Installation Guide

**Commerce AI Suite Product Recommender - Submodule Installation**

> **Important:** This submodule requires the Commerce AI parent module to be
> installed and enabled first.

## Quick Start

### 1. Install Dependencies

From the Drupal root directory:

```bash
composer require google/cloud-storage:^1.30
```

### 2. Enable the Parent Module

```bash
drush en commerce_ai_suite -y
```

### 3. Enable This Submodule

```bash
drush en commerce_ai_suite_product_recommender -y
drush cr
```

### 4. Install and Configure Key Module

```bash
drush en key -y
```

Create a key to store your service account:
1. Go to `/admin/config/system/keys/add`
2. Key name: `gcs_service_account`
3. Key type: `Authentication`
4. Key provider: `Configuration`
5. Key value: Paste your service account JSON

### 5. Configure GCP

#### Create Service Account
1. Visit [GCP Console](https://console.cloud.google.com/iam-admin/serviceaccounts)
2. Create service account with roles:
   - Storage Object Admin
   - Vertex AI User
3. Create and download JSON key

#### Create GCS Bucket
```bash
gsutil mb -p acro-corp-ai-testing -l us-east4 \
  gs://ai-development-commerce-products
```

#### Configure Agentspace
1. Go to Vertex AI → Agent Builder
2. Create new Agentspace app
3. Add GCS data source pointing to your bucket
4. Note App ID, Config ID, and API Key

### 6. Configure Module

Navigate to: `/admin/commerce/config/ai-product-recommender`

Fill in:
- **GCP Project ID**: `acro-corp-ai-testing`
- **GCS Bucket Name**: `ai-development-commerce-products`
- **Service Account Key**: Select the key from the Key module
- **Vertex AI Endpoint**: `https://us-east4-aiplatform.googleapis.com`
- **Vertex AI Location**: `us-east4`
- **Agentspace App ID**: (from Vertex AI console)
- **Agentspace Config ID**: (from Vertex AI console)
- **Agentspace API Key**: (from Vertex AI console)

### 7. Initial Product Sync

```bash
drush commerce-ai-suite-product-recommender:sync-products
drush cron
```

### 8. Place Block

1. Go to `/admin/structure/block`
2. Place "AI Product Recommendations" block
3. Configure visibility for authenticated users
4. Save

## Verification

Check that products were exported:
```bash
gsutil ls gs://ai-development-commerce-products/products/
```

Check logs:
```bash
drush watchdog:show --type=commerce_ai_suite_product_recommender
```

## Troubleshooting

### Error: "Class 'Google\Cloud\Storage\StorageClient' not found"
**Solution**: Run `composer require google/cloud-storage`

### Error: "GCS service account key is not configured"
**Solution**: Create a key in the Key module and select it in settings

### No recommendations showing
**Solution**:
1. Check that products are published:
   `drush sql-query "SELECT COUNT(*) FROM commerce_product WHERE status=1"`
2. Verify queue processed: `drush queue:list`
3. Check GCS files exist: `gsutil ls gs://your-bucket/products/`

### Agentspace not returning results
**Solution**:
1. Test Agentspace directly via Cloud Console
2. Verify data source is configured correctly
3. Check API key permissions
4. Review Vertex AI logs

## Next Steps

- Customize product fields in
  `ProductExporterService::transformProductToDocument()`
- Adjust recommendation block template in your theme
- Configure cron interval for your needs
- Add custom CSS for recommendation styling
- Set up monitoring/analytics for recommendation performance
