<?php

namespace Drupal\commerce_ai_suite_product_recommender\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines the AI Provider plugin annotation object.
 *
 * @Annotation
 */
class AiProvider extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the AI provider.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the AI provider.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The weight of the provider (for sorting in UI).
   *
   * @var int
   */
  public $weight = 0;

}
