<?php

namespace Drupal\commerce_ai_suite_product_recommender\Commands;

use Drupal\commerce_ai_suite_product_recommender\Service\ProductExporterService;
use Drush\Commands\DrushCommands;

/**
 * Drush commands for Commerce AI Suite Product Recommender.
 */
class ProductSyncCommands extends DrushCommands {

  /**
   * The product exporter service.
   *
   * @var \Drupal\commerce_ai_suite_product_recommender\Service\ProductExporterService
   */
  protected $productExporter;

  /**
   * Constructs a ProductSyncCommands object.
   *
   * @param \Drupal\commerce_ai_suite_product_recommender\Service\ProductExporterService $product_exporter
   *   The product exporter service.
   */
  public function __construct(
    ProductExporterService $product_exporter,
  ) {
    parent::__construct();
    $this->productExporter = $product_exporter;
  }

  /**
   * Syncs products to GCS for AI recommendations.
   *
   * @command commerce-ai-suite-product-recommender:sync-products
   * @aliases cairec-sync
   * @usage commerce-ai-suite-product-recommender:sync-products
   *   Queue all active products for export to GCS.
   */
  public function syncProducts() {
    $this->output()->writeln('Starting product sync to GCS...');

    $count = $this->productExporter->queueProductsForExport();

    if ($count > 0) {
      $message = "Successfully queued {$count} products for export.";
      $this->output()->writeln($message);
      $this->output()->writeln('Run cron to process the queue: drush cron');
    }
    else {
      $this->output()->writeln('No products found to export.');
    }
  }

}
