<?php

namespace Drupal\commerce_ai_suite_product_recommender\Plugin\AiProvider;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Defines an interface for AI Provider plugins.
 */
interface AiProviderInterface extends PluginInspectionInterface {

  /**
   * Gets the label of the AI provider.
   *
   * @return string
   *   The label.
   */
  public function getLabel();

  /**
   * Gets the description of the AI provider.
   *
   * @return string
   *   The description.
   */
  public function getDescription();

  /**
   * Gets recommendations based on user history.
   *
   * @param string $user_history
   *   JSON-encoded user order history.
   *
   * @return array|null
   *   Array of recommendations or NULL on failure.
   *   Each recommendation should have: id, title, price, reason.
   */
  public function getRecommendations($user_history);

  /**
   * Gets the configuration form fields for this provider.
   *
   * @return array
   *   Form API array of configuration fields.
   */
  public function getConfigurationForm();

  /**
   * Validates the provider configuration.
   *
   * @param array $config
   *   The configuration array.
   *
   * @return array
   *   Array of validation errors, empty if valid.
   */
  public function validateConfiguration(array $config);

  /**
   * Checks if the provider is properly configured.
   *
   * @return bool
   *   TRUE if configured, FALSE otherwise.
   */
  public function isConfigured();

}
