<?php

namespace Drupal\commerce_ai_suite_product_recommender\Plugin\QueueWorker;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\commerce_ai_suite_product_recommender\Service\ProductExporterService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Processes product export queue items.
 *
 * @QueueWorker(
 *   id = "commerce_ai_suite_product_recommender_export",
 *   title = @Translation("Product Export Worker"),
 *   cron = {"time" = 60}
 * )
 */
class ProductExportWorker extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * The product exporter service.
   *
   * @var \Drupal\commerce_ai_suite_product_recommender\Service\ProductExporterService
   */
  protected $productExporter;

  /**
   * Constructs a ProductExportWorker object.
   *
   * @param array $configuration
   *   A configuration array with info about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\commerce_ai_suite_product_recommender\Service\ProductExporterService $product_exporter
   *   The product exporter service.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    ProductExporterService $product_exporter,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->productExporter = $product_exporter;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(
    ContainerInterface $container,
    array $configuration,
    $plugin_id,
    $plugin_definition,
  ) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('commerce_ai_suite_product_recommender.product_exporter')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    $chunk_index = $data['chunk_index'] ?? 0;
    $product_ids = $data['product_ids'] ?? [];

    if (empty($product_ids)) {
      return;
    }

    $this->productExporter->exportProductChunk($product_ids, $chunk_index);
  }

}
