<?php

declare(strict_types=1);

namespace Drupal\commerce_alma_test\Controller;

use Drupal\commerce_alma_test\Api\Endpoints\Payments;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use GuzzleHttp\ClientInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Fakes the Alma notification.
 */
class AlmaController extends ControllerBase {

  /**
   * The HTTP client service.
   *
   * @var \GuzzleHttp\ClientInterface
   */
  protected $httpClient;

  /**
   * Constructs a TestController object.
   *
   * @param \GuzzleHttp\ClientInterface $http_client
   *   The HTTP client service.
   */
  public function __construct(ClientInterface $http_client) {
    $this->httpClient = $http_client;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('http_client')
    );
  }

  /**
   * Simulates a notification from Alma.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   A redirect response to the payment return route.
   */
  public function notify(): RedirectResponse {
    $notify_url = Url::fromRoute('commerce_payment.notify', [
      'commerce_payment_gateway' => 'offsite',
    ], ['absolute' => TRUE])->toString();

    $this->httpClient->get($notify_url, [
      'query' => [
        'pid' => Payments::VALID_PID,
      ],
    ]);

    return new RedirectResponse(
      Url::fromRoute('commerce_payment.checkout.return', [
        'commerce_order' => 1,
        'step' => 'payment',
      ], ['absolute' => TRUE])->toString()
    );
  }

}
