<?php

declare(strict_types=1);

namespace Drupal\commerce_alma_test\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_alma\Plugin\Commerce\PaymentGateway\OffsitePaymentGateway;
use Drupal\commerce_alma_test\Api\Client;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides the Alma offsite Checkout payment gateway.
 */
class OffsiteTestPaymentGateway extends OffsitePaymentGateway {

  /**
   * The Alma API client.
   *
   * @var Drupal\commerce_alma\Client
   */
  protected $api;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);

    if (!empty($instance->configuration['mode']) && !empty($instance->configuration['api_key'])) {
      $instance->api = new Client();
    }

    return $instance;
  }
}
