<?php

namespace Drupal\Tests\commerce_alma\Kernel;

use Drupal\commerce_order\Entity\Order;
use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\commerce_order\Entity\OrderItem;
use Drupal\commerce_payment\Entity\Payment;
use Drupal\commerce_payment\Entity\PaymentGateway;
use Drupal\commerce_payment\Entity\PaymentGatewayInterface;
use Drupal\commerce_payment\Entity\PaymentInterface;
use Drupal\Tests\commerce_order\Kernel\OrderKernelTestBase;

/**
 * Alma kernel test.
 */
abstract class KernelTestBase extends OrderKernelTestBase {

  /**
   * The development API key.
   */
  const TEST_API_KEY = 'sk_test_4DA6bUFeQPiECej4NsIqeD6N';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'commerce_price',
    'commerce_payment',
    'commerce_alma',
    'commerce_alma_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('commerce_payment');

    $currency_importer = $this->container->get('commerce_price.currency_importer');
    $currency_importer->import('EUR');
  }

  /**
   * Generates a payment gateway.
   *
   * @return \Drupal\commerce_payment\Entity\PaymentGatewayInterface
   *   The Alma gateway.
   */
  protected function createGateway(array $values): PaymentGatewayInterface {
    $gateway = PaymentGateway::create($values);
    $gateway->save();
    return $this->reloadEntity($gateway);
  }

  /**
   * Creates an order entity.
   *
   * @param array $values
   *   The values to create the entity with.
   *
   * @return \Drupal\commerce_order\Entity\OrderInterface
   *   The order entity.
   */
  protected function createOrder(array $values): OrderInterface {
    $items = [];
    foreach ($values['items'] as $item_values) {
      $items[] = OrderItem::create($item_values)->save();
    }
    unset($values['items']);
    $order = Order::create($values);
    $order->setItems($items);
    $order->save();
    return $this->reloadEntity($order);
  }

  /**
   * Creates a payment entity.
   *
   * @param array $values
   *   The values to create the entity with.
   *
   * @return \Drupal\commerce_payment\Entity\PaymentInterface
   *   The payment entity.
   */
  protected function createPayment(array $values): PaymentInterface {
    $payment = Payment::create($values);
    $payment->save();
    return $this->reloadEntity($payment);
  }

}
