<?php

declare(strict_types=1);

namespace Drupal\commerce_amazon_sp_api\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a marketplace entity type.
 */
interface AmazonMarketplaceInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Get the name of the app.
   */
  public function getName(): string;

  /**
   * Get the description of the app.
   */
  public function getDescription(): ?string;

  /**
   * Get order types.
   */
  public function getOrderTypes(): array;

  /**
   * Get order types ids.
   */
  public function getOrderTypeIds(): array;

  /**
   * Get stores.
   */
  public function getStores(): array;

  /**
   * Get store ids.
   */
  public function getStoreIds(): array;

  /**
   * Get amazon item ids.
   */
  public function getItemsIds(): array;

  /**
   * Get the amazon items.
   */
  public function getItems(): array;

  /**
   * Set the items.
   */
  public function setItems(array $items): static;

  /**
   * Determine if it has items.
   */
  public function hasItems(): bool;

  /**
   * Add new item.
   */
  public function addItem(AmazonItemInterface $item): static;

  /**
   * Remove the item.
   */
  public function removeItem(AmazonItemInterface $item): static;

  /**
   * Has an item.
   */
  public function hasItem(AmazonItemInterface $item): bool;

  /**
   * Get the amazon app.
   */
  public function getAmazonApp(): ?AmazonAppInterface;

  /**
   * Set the amazon app.
   */
  public function setAmazonApp(AmazonAppInterface $app): static;

  /**
   * Get marketplace id.
   */
  public function getMarketplaceId(): ?string;

  /**
   * Set marketplace id.
   */
  public function setMarketplaceId(string $marketplace_id): static;

  /**
   * Determine if marketplace is eligible.
   */
  public function isEligible(OrderInterface $order): bool;

  /**
   * Preview fulfillment.
   */
  public function previewFulfillment(): bool;

  /**
   * Determine if sync inventory is incremental.
   */
  public function isIncrementalSync(): bool;

  /**
   * Determine if marketplace is eligible for sync.
   */
  public function syncItems(): bool;

}
