# Commerce Asaas

Drupal Commerce integration module with Asaas Bank payment system.

## Features

- **Credit Card**: Credit card payment processing
- **PIX**: Instant payments via PIX with QR Code
- **ZIP Code Lookup**: Automatic address filling via ViaCEP
- **Webhooks**: Payment status notification handling
- **Sandbox Environment**: Development environment testing

## Installation

1. Install required dependencies:
   ```bash
   composer require drupal/commerce
   composer require drupal/brazilian_ids
   composer require guzzlehttp/guzzle
   ```

2. Enable the module:
   ```bash
   drush en commerce_asaas
   ```

3. Configure payment gateways at `/admin/commerce/config/payment-gateways`

## Configuration

### 1. Credit Card

1. Go to `/admin/commerce/config/payment-gateways`
2. Add a new "Asaas Credit Card On-site" gateway
3. Configure API keys (live and sandbox)
4. Set mode (test or live)

### 2. PIX

1. Add a new "Asaas PIX" gateway
2. Configure API keys
3. The system will automatically generate QR Codes for payment


### 4. Webhooks

1. Configure webhook endpoint in Asaas panel:
   `https://yourdomain.com/commerce/asaas/webhook`
2. The system will automatically process status notifications

## Additional Fields

The module automatically adds the following fields to customer profile:

- **CPF/CNPJ**: Required field for identification
- **Mobile Phone**: For customer contact

## ZIP Code Lookup

The system integrates with ViaCEP for automatic address filling:

- Enter ZIP code in postal_code field
- Address fields will be automatically filled
- Works in checkout and customer profile forms

## Development

### Module Structure

```
src/
├── ApiCalls.php                    # Asaas API calls
├── Controller/
│   ├── WebhookController.php       # Webhook processing
│   └── PaymentStatusController.php # Status checking
├── Plugin/
│   ├── Commerce/
│   │   ├── PaymentGateway/         # Payment gateways
│   │   └── PaymentMethodType/      # Payment method types
│   └── PluginForm/                 # Payment forms
└── Render/
    └── PreRender.php               # Render callbacks
```

### Logs

The module logs to `admin/reports/dblog` with "commerce_asaas" channel.

### Testing

Use Asaas sandbox environment for testing:
- URL: https://sandbox.asaas.com/api/v3/
- Set mode as "test" in gateways

## Support

For questions or issues:
- Asaas Documentation: https://docs.asaas.com/
- Drupal Logs: `/admin/reports/dblog`
- Asaas Support Channel: https://www.asaas.com/desenvolvedores
