(function (Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.commerceAsaasPixPayment = {
    attach: function (context, settings) {
      if (typeof drupalSettings.commerce_asaas === 'undefined') {
        return;
      }

      const paymentId = drupalSettings.commerce_asaas.payment_id;
      const checkUrl = drupalSettings.commerce_asaas.check_url;

      if (!paymentId || !checkUrl) {
        return;
      }

      // Add manual reload button
      const reloadButton = document.createElement('button');
      reloadButton.textContent = 'Refresh PIX Information';
      reloadButton.className = 'button';
      reloadButton.onclick = function() {
        window.location.reload();
      };

      // Find the loading message and add the button
      const loadingMessage = document.querySelector('.pix-loading-message');
      if (loadingMessage) {
        loadingMessage.appendChild(reloadButton);
      }

             // Check if PIX data is already available on the page
             const pixQrCode = document.querySelector('.pix-qr-code');
             const pixCode = document.querySelector('textarea[name*="pix_code"]');

             if (pixQrCode && pixCode) {
               console.log('PIX data already available, no need to poll');
               return;
             }

             // Check payment status every 2 seconds for PIX data
             const checkInterval = setInterval(function() {
               console.log('Checking PIX payment status...');
               fetch(checkUrl)
                 .then(response => response.json())
                 .then(data => {
                   console.log('PIX payment status response:', data);
                   if (data.is_paid) {
                     clearInterval(checkInterval);
                     // Redirect to success page or show success message
                     window.location.href = window.location.href + '?status=paid';
                   } else if (data.pix_available) {
                     // PIX data is now available, reload the page
                     console.log('PIX data available, reloading page...');
                     clearInterval(checkInterval);
                     window.location.reload();
                   }
                 })
                 .catch(error => {
                   console.error('Error checking payment status:', error);
                 });
             }, 2000);

      // Stop checking after 10 minutes
      setTimeout(function() {
        clearInterval(checkInterval);
      }, 600000);
    }
  };

})(Drupal, drupalSettings);
