<?php

namespace Drupal\commerce_asaas\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\PaymentMethodTypeBase;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\commerce_payment\Attribute\CommercePaymentMethodType;

/**
 * Provides the PIX payment method type.
 */
#[CommercePaymentMethodType(
  id: "pix",
  label: new TranslatableMarkup("PIX"),
)]
class Pix extends PaymentMethodTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return new TranslatableMarkup('PIX');
  }

  /**
   * {@inheritdoc}
   */
  public function getCreateLabel() {
    return new TranslatableMarkup('PIX');
  }

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    return $this->getLabel();
  }

}
