<?php

namespace Drupal\commerce_asaas\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_payment\Attribute\CommercePaymentMethodType;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\PaymentMethodTypeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Provides the Credit Card payment method type.
 */
#[CommercePaymentMethodType(
  id: "credit_card",
  label: new TranslatableMarkup("Credit Card"),
)]
class CreditCard extends PaymentMethodTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return $this->t('Credit Card');
  }

  /**
   * {@inheritdoc}
   */
  public function getCreateLabel() {
    return $this->t('Credit Card');
  }

  /**
   * {@inheritdoc}
   */
  public function buildLabel($payment_method) {
    $card_type = $payment_method->card_type->value;
    $card_number = $payment_method->card_number->value;
    $expires = $payment_method->card_exp_month->value . '/' . $payment_method->card_exp_year->value;

    return $this->t('@card_type ending in @number (@expires)', [
      '@card_type' => $card_type,
      '@number' => $card_number,
      '@expires' => $expires,
    ]);
  }

}
