<?php

namespace Drupal\commerce_asaas\PluginForm\Onsite;

use Drupal\Core\Form\FormStateInterface;
use Drupal\commerce_payment\PluginForm\PaymentMethodAddForm as BasePaymentMethodAddForm;

/**
 * Create the credit card payment form.
 */
class PaymentMethodAddForm extends BasePaymentMethodAddForm {

  /**
   * {@inheritdoc}
   */
  protected function buildCreditCardForm(array $element, FormStateInterface $form_state) {
    $element = parent::buildCreditCardForm($element, $form_state);

    /** @var \Drupal\commerce_asaas\Plugin\Commerce\PaymentGateway\OnsiteCreditCardInterface $plugin */
    $plugin = $this->plugin;

    $sandbox = ($plugin->getMode() == 'test');

    if ($sandbox) {
      // Default to a known valid test credit card number.
      $element['number']['#default_value'] = '4111111111111111';
    }

    // Creating new fields on credit card form.
    $element['installments'] = [
      '#type' => 'select',
      '#title' => $this->t('Installments'),
      '#description' => $this->t('Select the number of installments.'),
      '#required' => FALSE,
      '#attributes' => ['id' => 'installments'],
    ];
    // Options to installments form.
    $element['installments']['#options'] = array_combine(range(1, 12), range(1, 12));
    asort($element['installments']['#options']);

    $element['holder_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Card Holder Name'),
      '#attributes' => [
        'autocomplete' => 'off',
        'id' => 'holder-name',
      ],
      '#required' => TRUE,
      '#description' => $this->t('Enter the name printed on the card.'),
    ];

    return $element;
  }

}
