<?php

/**
 * @file
 * Test script to simulate Asaas webhook for PIX payment.
 *
 * Usage: php test_webhook.php [payment_id]
 */

// Get payment ID from command line argument
$payment_id = $argv[1] ?? 'test_payment_123';

// Webhook URL
$webhook_url = 'https://uni.lndo.site/commerce/asaas/webhook';

// Simulate PAYMENT_RECEIVED event for PIX
$webhook_data = [
  'event' => 'PAYMENT_RECEIVED',
  'payment' => [
    'id' => $payment_id,
    'status' => 'RECEIVED',
    'billingType' => 'PIX',
    'value' => 100.00,
    'dueDate' => date('Y-m-d'),
    'description' => 'Test PIX Payment',
    'externalReference' => '53', // Order ID
  ]
];

// Send webhook
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $webhook_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($webhook_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  'Content-Type: application/json',
  'User-Agent: Asaas-Webhook/1.0'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Webhook sent to: $webhook_url\n";
echo "Payment ID: $payment_id\n";
echo "HTTP Code: $http_code\n";
echo "Response: $response\n";

if ($http_code == 200) {
  echo "✅ Webhook sent successfully!\n";
} else {
  echo "❌ Webhook failed with HTTP code: $http_code\n";
}
