# Changelog

All notable changes to this project will be documented in this file.

The format is inspired by Keep a Changelog. Dates use YYYY-MM-DD.

## 1.0.0 (2025-12-09)

### Added
- Event Subscriber to react on Commerce Product updates (availability changes).
- Queue API workers:
  - `commerce_back_in_stock_customer` for customer notifications.
  - `commerce_back_in_stock_admin` for admin stock notices.
- Service `NotificationManager` with centralized business logic.
- Drush commands:
  - `commerce-back-in-stock:run` (alias `cbs:run`) — run both queues.
  - `commerce-back-in-stock:seed` (alias `cbs:seed`) — seed test subscriptions.
- Translations: `translations/ru.po`, `translations/uk.po`.
- Tests: Unit, Kernel, and Functional (admin routes and settings form).

### Changed
- Migrated from annotations to PHP 8 Attributes for the content entity.
- Switched forms and controllers to Dependency Injection; added strict types.
- Moved heavy logic out of `.module` to service + queues.
- AJAX UX: form now returns `AjaxResponse` with `ReplaceCommand` and optional auto-close.

### Removed
- Legacy `hook_commerce_product_update()` (replaced by event subscriber).
- Deprecated jQuery UI effects from `hook_form_alter()`.
- Unused Twig template and `hook_theme()`.

### Upgrade notes (from commerce_stock_notify/mynotify)
- Module renamed to `commerce_back_in_stock`.
- Entity renamed to `StockSubscription` with machine name `commerce_back_in_stock`.
- Routes/permissions were updated; clear caches after updating.
- Token context variable kept as `mynotify` for backward compatibility in email templates.
