Commerce Stock Notify

Allows customers to subscribe to out-of-stock products and receive an email notification when the product becomes available.

Features
- Subscription form: replaces the "Add to cart" button with a "Notify me" modal when a product is out of stock.
- Admin notifications: optional email to admin on new subscription and when stock returns.
- Customer notifications: emails are sent asynchronously when stock becomes available.
- Token support: customizable email templates using tokens.
- Commerce integration: works with Drupal Commerce product entities.
- Queue API: notifications are queued to avoid timeouts during product updates.
- Drush commands: run queues and seed test subscriptions.

Requirements
- Drupal 9.5/10/11
- Modules: Token, Commerce

Installation
1. Require the module via Composer: composer require drupal/commerce_back_in_stock
2. Enable the module: drush en commerce_back_in_stock -y

Configuration
1. Go to Commerce → Configuration → Stock Notify Settings.
   - Configure popup options (dialog title, button label, auto-close on success).
   - Configure email templates (subjects and bodies) for admin and customer.
   - Set the admin email address (optional).
2. Ensure Cron is running so the queues are processed regularly.

Drush commands
- Run queues (customer and admin): drush commerce-back-in-stock:run (alias: drush cbs:run)
- Seed test subscriptions for a product: drush commerce-back-in-stock:seed <product_id> [count]

Architecture
- Product updates are captured via an Event Subscriber. When a product becomes available, subscription IDs are added to queues.
- Queue workers handle customer emails (one item per subscription ID) and a single admin email per product event.
- Storage access is optimized via EntityQuery to fetch only IDs before queueing.

Translations
- Default strings are in English. Ready-made translations are supplied in translations/ (ru.po, uk.po).
- You can also manage translations via the Interface Translation UI or import additional .po files.

Troubleshooting / FAQ
- Emails are not sent
  - Ensure a mail transport is configured (e.g. Symfony Mailer, SMTP module, or system MTA). On dev, PHP mail() may be disabled.
  - Check that the admin email is set in Stock Notify settings if you expect admin notifications.
  - Run queues manually to verify: `drush commerce-stock-notify:run`.
- Queue items are not processed on cron
  - Make sure cron is running (via core cron or Ultimate Cron).
  - If using Ultimate Cron, set the module’s internal interval to "Every time" (0) on the Cleaner analogy, and schedule the jobs in Ultimate Cron UI.
- Modal doesn’t close after submit
  - Enable "Close modal on success" in settings. Without it, the success text replaces the form inside the modal.
- The "Notify me" link does not appear
  - Ensure the product is considered out of stock (or price is zero) and the setting "Replace button add to cart" is enabled.
  - If you have custom availability logic, implement `hook_mynotify_is_availability_alter()` to influence availability detection.

Development
- Coding standards: run phpcs for Drupal coding standards.
- Tests: add Kernel and Functional tests for storage, queue workers, forms, and routes.

License
GPL-2.0-or-later
