<?php

declare(strict_types=1);

namespace Drupal\commerce_back_in_stock;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Access\AccessResultReasonInterface;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access control handler for StockSubscription entities.
 *
 * Decides access based on module permissions for view, edit, delete,
 * and create operations.
 */
class CommerceStockAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account): AccessResultInterface {
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view commerce_back_in_stock entity');

      case 'edit':
        return AccessResult::allowedIfHasPermission($account, 'edit commerce_back_in_stock entity');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete commerce_back_in_stock entity');
    }
    return AccessResult::allowed();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL): AccessResultReasonInterface|AccessResult|AccessResultInterface {
    return AccessResult::allowedIfHasPermission($account, 'add commerce_back_in_stock entity');
  }

}
