<?php

declare(strict_types=1);

namespace Drupal\commerce_back_in_stock;

use Drupal\commerce_product\Entity\ProductInterface;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a StockSubscription entity.
 */
interface CommerceStockNotifyInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Gets the product_id.
   *
   * @return string|null
   *   Product ID of the subscription.
   */
  public function getProductId(): ?string;

  /**
   * Sets the subscription product_id.
   *
   * @param string|int $product_id
   *   The product ID.
   *
   * @return $this
   */
  public function setProductId($product_id): self;

  /**
   * Gets the Product.
   *
   * @return \Drupal\commerce_product\Entity\ProductInterface|null
   *   Product entity.
   */
  public function getProduct(): ?ProductInterface;

  /**
   * Gets the name.
   *
   * @return string
   *   Name of the subscriber.
   */
  public function getName(): string;

  /**
   * Sets the name.
   *
   * @param string $name
   *   The name.
   *
   * @return $this
   */
  public function setName(string $name): self;

  /**
   * Gets the email.
   *
   * @return string
   *   Email of the subscriber.
   */
  public function getMail(): string;

  /**
   * Sets the email.
   *
   * @param string $mail
   *   The email.
   *
   * @return $this
   */
  public function setMail(string $mail): self;

  /**
   * Gets the phone.
   *
   * @return string|null
   *   Phone number.
   */
  public function getPhone(): ?string;

  /**
   * Sets the phone.
   *
   * @param string $phone
   *   The phone number.
   *
   * @return $this
   */
  public function setPhone(string $phone): self;

  /**
   * Gets the notified status.
   *
   * @return bool
   *   TRUE if notified, FALSE otherwise.
   */
  public function isNotified(): bool;

  /**
   * Sets the notified status.
   *
   * @param bool $notified
   *   The notified status.
   *
   * @return $this
   */
  public function setNotified(bool $notified): self;

  /**
   * Gets the additional text.
   *
   * @return string|null
   *   Text message.
   */
  public function getText(): ?string;

  /**
   * Sets the additional text.
   *
   * @param string $text
   *   The text message.
   *
   * @return $this
   */
  public function setText(string $text): self;

}
