<?php

namespace Drupal\commerce_back_in_stock;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Url;

/**
 * Provides a list controller for mynotify entity.
 *
 * @ingroup mynotify
 */
class StockSubscriptionListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    $build = [];
    /*
    $build['description'] = [
    '#markup' => '',
    ];
     */
    $build += parent::render();
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultOperations(EntityInterface $entity): array {
    $operations = parent::getDefaultOperations($entity);
    // Remove destination param from operation URLs.
    foreach ($operations as &$operation) {
      if ($operation['url'] instanceof Url) {
        $query = $operation['url']->getOption('query');
        unset($query['destination']);
        $operation['url']->setOption('query', $query);
      }
    }
    unset($operation);
    return $operations;
  }

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['id'] = $this->t('ID');
    $header['name'] = $this->t('Name');
    $header['mail'] = $this->t('Mail');
    $header['phone'] = $this->t('Phone');
    $header['notified'] = $this->t('Notified');
    $header['product_id'] = $this->t('Product');
    $header['uid'] = $this->t('Owner');
    $header['created'] = $this->t('Created');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Core\Entity\EntityMalformedException
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public function buildRow(EntityInterface $mynotify) {
    /**
     * @var StockSubscription $mynotify
*/
    /**
     * @var Product $product
*/
    $product = $mynotify->getProduct();
    $row = [];
    if ($product) {
      $account = $mynotify->getOwner();
      $row['id'] = $mynotify->id();
      $row['name'] = $mynotify->getName();
      $row['mail'] = $mynotify->getMail();
      $row['phone'] = $mynotify->getPhone();
      $row['notified'] = $mynotify->isNotified() ? $this->t('Yes') : $this->t('No');
      $row['product_id'] = $product->toLink();
      $row['uid'] = $account->toLink();
      $created = (int) $mynotify->get('created')->value;
      $row['created'] = \Drupal::service('date.formatter')
        ->format($created, 'medium');
    }
    else {
      $mynotify->delete();
    }
    return $row + parent::buildRow($mynotify);
  }

}
