<?php

declare(strict_types=1);

namespace Drupal\commerce_back_in_stock;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;

/**
 * Class StockSubscriptionStorage.
 *
 * @package Drupal\commerce_back_in_stock
 */
class StockSubscriptionStorage extends SqlContentEntityStorage implements StockSubscriptionStorageInterface {

  /**
   * {@inheritdoc}
   */
  public function loadPendingNotifications($product_id = NULL): array {
    $mynotifies = $this->loadByProperties(
          [
            'product_id' => $product_id,
            'notified' => 0,
          ]
      );
    return $mynotifies;
  }

  /**
   * {@inheritdoc}
   */
  public function loadPendingNotificationIds($product_id = NULL): array {
    $query = $this->getQuery()
      ->condition('notified', 0);
    if ($product_id !== NULL) {
      $query->condition('product_id', $product_id);
    }
    // We don't need access checks for internal queueing.
    $query->accessCheck(FALSE);
    $ids = $query->execute();
    if (empty($ids)) {
      return [];
    }
    // Ensure numeric array of IDs.
    return array_values(array_map('intval', $ids));
  }

}
