<?php

declare(strict_types=1);

namespace Drupal\commerce_back_in_stock;

use Drupal\Core\Entity\ContentEntityStorageInterface;

/**
 * Storage interface for StockSubscription entities.
 */
interface StockSubscriptionStorageInterface extends ContentEntityStorageInterface {

  /**
   * Loads not-notified subscriptions, optionally filtered by product.
   *
   * @param int|string|null $product_id
   *   The Commerce product ID to filter by, or NULL for all products.
   *
   * @return \Drupal\commerce_back_in_stock\Entity\StockSubscription[]
   *   A list of subscription entities.
   */
  public function loadPendingNotifications($product_id = NULL): array;

  /**
   * Gets IDs of not-notified subscriptions for a product via EntityQuery.
   *
   * @param int|string|null $product_id
   *   Commerce Product ID.
   *
   * @return int[]
   *   Array of entity IDs (integers).
   */
  public function loadPendingNotificationIds($product_id = NULL): array;

}
