/**
 * @file
 * Defines behaviors for the CardPointe hosted iframe payment method form.
 */
((Drupal) => {
  Drupal.behaviors.hostedIframe = {
    attach() {
      let token = null;
      const tokenField = document.getElementById('token');
      const expirationField = document.getElementById('expiration');

      if (!tokenField || !expirationField) {
        return;
      }

      const form = document.querySelector(
        '.commerce-checkout-flow-multistep-default',
      );
      if (form.classList.contains('hosted-iframe-form')) {
        return;
      }
      form.classList.add('hosted-iframe-form');
      const submitButton = form?.querySelector('.button--primary');

      if (!form || !submitButton) {
        return;
      }

      window.addEventListener('message', (event) => {
        token = JSON.parse(event.data);
        // Set the token and expiration to the hidden form fields.
        tokenField.value = token.message;
        expirationField.value = token.expiry;
      });

      const tokenIsValid = () => {
        return token && token.message && token.expiry;
      };

      submitButton?.addEventListener('click', (event) => {
        // If the token is empty, delay the submission
        // so the token can generate first.
        if (!tokenIsValid()) {
          event.preventDefault();
          submitButton.disabled = true;
          setTimeout(() => {
            if (tokenIsValid()) {
              form.submit();
            } else {
              submitButton.disabled = false;
            }
          }, 1000);
        }
      });
    },
  };
})(Drupal);
