<?php

namespace Drupal\commerce_cardpointe\Form;

use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Provides a form for deleting a terminal.
 */
class TerminalDeleteForm extends ContentEntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function getQuestion(): TranslatableMarkup {
    return $this->t('Are you sure you want to delete %label?', [
      '%label' => $this->getEntity()->label() ?? $this->getEntity()->id(),
    ]);
  }

}
