<?php

namespace Drupal\commerce_cart_links\Routing;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Subscriber for Cart links routes.
 */
class CartLinksRouteSubscriber extends RouteSubscriberBase {

  /**
   * Constructs a CartLinksRouteSubscriber object.
   *
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $moduleHandler
   *   The module handler.
   */
  public function __construct(protected ModuleHandlerInterface $moduleHandler) {}

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    if ($route = $collection->get('commerce_cart_links.process_cart_links')) {
      // If the redirect module is installed, it will cause a 403 error,
      // so we need to disable normalization.
      if ($this->moduleHandler->moduleExists('redirect')) {
        $route->setDefault('_disable_route_normalizer', TRUE);
      }
    }
  }

}
