(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.initCashpressoCheckout = {
    attach: function (context) {
      const $elements =  $(once('init-cashpresso-checkout', '#cashpresso-checkout', context));
      $elements.each(function () {
        const cpSettings = drupalSettings.commerce_cashpresso;
        const cp = document.createElement('script');
        cp.id = 'c2CheckoutScript';
        cp.type = 'text/javascript';
        $.each(cpSettings.data, function (key, value) {
          cp.setAttribute('data-c2-' + key, value);
        });
        cp.src = cpSettings.url;
        cp.onload = function () {
          if (window.C2EcomCheckout) {
            window.C2EcomCheckout.init();
          }
        };
        const s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(cp, s);
      });
    }
  };

})(jQuery, Drupal, drupalSettings);
