(function ($, Drupal, drupalSettings) {
  'use strict';

  if (!drupalSettings.commerce_cashpresso) {
    return;
  }
  const cpSettings = drupalSettings.commerce_cashpresso;
  const cp = document.createElement('script');
  cp.id = 'c2StaticLabelScript';
  cp.type = 'text/javascript';
  cp.setAttribute('defer', 'true');
  jQuery.each(cpSettings.data, function (key, value) {
    cp.setAttribute('data-c2-' + key, value);
  });
  cp.src = cpSettings.url;
  const s = document.getElementsByTagName('script')[0];
  s.parentNode.insertBefore(cp, s);

  Drupal.behaviors.cashpressoProductPreviewStatic = {
    attach: function (context) {
      const $elements =  $(once('init-cashpresso-product-static', '.c2-static-label', context));
      $elements.each(function () {
        $(this).on('click', function(e) {
          e.preventDefault();
          const amount = $(this).data('amount');
          C2EcomWizard.startOverlayWizard(amount);
        });
      });
    }
  };
})(jQuery, Drupal, drupalSettings);
