<?php

namespace Drupal\commerce_cashpresso\EventSubscriber;

use Drupal\commerce_cashpresso\Plugin\Commerce\PaymentGateway\CashpressoGatewayInterface;
use Drupal\state_machine\Event\WorkflowTransitionEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Auto-cancellation of orders having a cancelled cashpresso payment.
 */
class PaymentWorkflowTransitionSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      'commerce_payment.expire.post_transition' => 'onCancel',
      'commerce_payment.void.post_transition' => 'onCancel',
    ];
  }

  /**
   * Reacts on cancelling a payment.
   *
   * Only for cashpresso payment, when the payment gets voided or timed out, we
   * will cancel the whole order.
   *
   * @param \Drupal\state_machine\Event\WorkflowTransitionEvent $event
   *   The workflow transition event.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public function onCancel(WorkflowTransitionEvent $event) {
    /** @var \Drupal\commerce_payment\Entity\PaymentInterface $payment */
    $payment = $event->getEntity();
    $order = $payment->getOrder();
    $payment_gateway_plugin = $payment->getPaymentGateway()->getPlugin();
    if ($payment_gateway_plugin instanceof CashpressoGatewayInterface && $order->getState()->isTransitionAllowed('cancel')) {
      $transition = $order->getState()->getWorkflow()->getTransition('cancel');
      if ($transition) {
        $order->getState()->applyTransition($transition);
        $order->save();
      }
    }
  }

}
