<?php

namespace Drupal\commerce_ccavenue\PluginForm\CCAvenueRedirect;

use Drupal\commerce_ccavenue\CCAvenueEncryption;
use Drupal\commerce_payment\PluginForm\PaymentOffsiteForm as BasePaymentOffsiteForm;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Provides the offsite payment form for CCAvenue.
 */
class PaymentCCAvenueForm extends BasePaymentOffsiteForm {

  const CCAVENUE_API_TEST_URL = 'https://secure.ccavenue.ae/transaction/transaction.do?command=initiateTransaction';
  const CCAVENUE_API_URL = 'https://secure.ccavenue.ae/transaction/transaction.do?command=initiateTransaction';

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    /** @var \Drupal\commerce_payment\Entity\PaymentInterface $payment */
    $payment = $this->entity;

    $redirect_method = 'post';
    /** @var \Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OffsitePaymentGatewayInterface $payment_gateway_plugin */
    $payment_gateway_plugin = $payment->getPaymentGateway()->getPlugin();

    $order = $payment->getOrder();
    $billing_profile = $order->getBillingProfile();
    $address = NULL;
    if ($billing_profile) {
      $address = $billing_profile->address->first();
    }

    $configuration = $payment_gateway_plugin->getConfiguration();
    $mode = $configuration['pmode'] ?? $payment_gateway_plugin->getMode();
    $merchant_id = $configuration['merchant_id'];
    $access_code = $configuration['access_code'];
    $working_key = $configuration['working_key'];
    $currency = $configuration['currency'];
    $language = $configuration['language'];

    $parameters = [
      'merchant_id' => $merchant_id,
      'order_id' => $order->id(),
      'tid' => $order->id(),
      'amount' => round($payment->getAmount()->getNumber(), 2),
      'currency' => $currency,
      'language' => $language,
      'redirect_url' => Url::fromRoute('commerce_payment.checkout.return', [
        'commerce_order' => $order->id(),
        'step' => 'payment',
      ], ['absolute' => TRUE])->toString(),
      'cancel_url' => Url::fromRoute('commerce_payment.checkout.cancel', [
        'commerce_order' => $order->id(),
        'step' => 'payment',
      ], ['absolute' => TRUE])->toString(),
      'billing_name' => $address ? $address->getGivenName() : "",
      'billing_address' => $address ? $address->getAddressLine1() : "",
      'billing_city' => $address ? $address->getLocality() : "",
      'billing_state' => $address ? $address->getAdministrativeArea() : "",
      'billing_country' => $address ? $address->getCountryCode() : "",
      'billing_zip' => $address ? $address->getPostalCode() : "",
      'billing_email' => $order->getEmail(),
    ];

    $merchantData = '';
    foreach ($parameters as $key => $value) {
      $merchantData .= $key . '=' . $value . '&';
    }

    $encrypt = new CCAvenueEncryption();
    $parameters['encRequest'] = $encrypt->encrypt($merchantData, $working_key);
    $parameters['access_code'] = $access_code;

    $redirect_url = ($mode == 'test') ? self::CCAVENUE_API_TEST_URL : self::CCAVENUE_API_URL;

    return $this->buildRedirectForm($form, $form_state, $redirect_url, $parameters, $redirect_method);
  }

}
