<?php

namespace Drupal\Tests\commerce_ccavenue\Unit;

use Drupal\commerce_ccavenue\CCAvenueEncryption;
use Drupal\Tests\UnitTestCase;

/**
 * Tests the CCAvenue encryption class.
 *
 * @group commerce_ccavenue
 * @coversDefaultClass \Drupal\commerce_ccavenue\CCAvenueEncryption
 */
class CCAvenueEncryptionTest extends UnitTestCase {

  /**
   * The CCAvenue encryption service.
   *
   * @var \Drupal\commerce_ccavenue\CCAvenueEncryption
   */
  protected $encryption;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->encryption = new CCAvenueEncryption();
  }

  /**
   * Tests encryption and decryption functionality.
   *
   * @covers ::encrypt
   * @covers ::decrypt
   */
  public function testEncryptDecrypt() {
    $plainText = 'merchant_id=test123&order_id=123&amount=100.00';
    $key = 'test_working_key';

    // Test encryption.
    $encrypted = $this->encryption->encrypt($plainText, $key);
    $this->assertNotEmpty($encrypted);
    $this->assertNotSame($plainText, $encrypted);

    // Test decryption.
    $decrypted = $this->encryption->decrypt($encrypted, $key);
    $this->assertSame($plainText, $decrypted);
  }

  /**
   * Tests hex to binary conversion.
   *
   * @covers ::hextobin
   */
  public function testHexToBin() {
    $hexString = '48656c6c6f20576f726c64'; // "Hello World" in hex
    $expected = 'Hello World';

    $result = $this->encryption->hextobin($hexString);
    $this->assertSame($expected, $result);
  }

  /**
   * Tests PKCS5 padding.
   *
   * @covers ::pkcs5_pad
   */
  public function testPkcs5Pad() {
    $plainText = 'Hello';
    $blockSize = 16;

    $padded = $this->encryption->pkcs5_pad($plainText, $blockSize);
    $this->assertSame(16, strlen($padded));
    $this->assertStringStartsWith('Hello', $padded);
  }

  /**
   * Tests encryption with empty data.
   */
  public function testEncryptEmptyData() {
    $plainText = '';
    $key = 'test_key';

    $encrypted = $this->encryption->encrypt($plainText, $key);
    $this->assertNotEmpty($encrypted);

    $decrypted = $this->encryption->decrypt($encrypted, $key);
    $this->assertSame($plainText, $decrypted);
  }

}
