# Commerce Checkout Lock

Prevents duplicate checkout submissions in Drupal Commerce.

## Features

- Server-side locking using Drupal's persistent lock backend
- Client-side double-click protection with visual feedback
- Automatic lock cleanup via kernel terminate safety net
- Configurable checkout pane for flexible placement

## Installation

1. Install as usual: `composer require drupal/commerce_checkout_lock`
2. Enable the module
3. Configure your checkout flow to include the "Checkout Lock" pane before payment

## Configuration

In your checkout flow settings, add the "Checkout Lock" pane to an existing step
(e.g., "Review" or "Payment") before any payment-related panes. The pane is
invisible to customers - it only attaches the protection logic to the form.

## How it works

1. When checkout form submits, JavaScript disables buttons and shows "Processing..."
2. The checkout pane acquires a persistent lock for the order
3. If lock fails (concurrent submission), user sees an error message
4. Lock releases on checkout completion or request termination (safety net)

## Requirements

- Drupal 10.3+ or 11.x
- Commerce 2.x or 3.x
