((Drupal, once) => {

  'use strict';

  Drupal.behaviors.commerceCheckoutLock = {
    attach: (context) => {
      const checkoutForms = once('checkout-lock', 'form.commerce-checkout-flow', context);

      checkoutForms.forEach((form) => {
        form.addEventListener('submit', () => {
          const submitButtons = form.querySelectorAll('.form-submit');

          submitButtons.forEach((button) => {
            if (button.dataset.processing) {
              return;
            }
            button.dataset.processing = 'true';

            setTimeout(() => {
              submitButtons.forEach((submitButton) => {
                submitButton.disabled = true;
              });
              button.value = Drupal.t('Processing...');
            }, 10);
          });
        });
      });
    }
  };

})(Drupal, once);
