<?php

declare(strict_types=1);

namespace Drupal\commerce_checkout_lock;

use Drupal\commerce_order\Entity\OrderInterface;

/**
 * Interface for checkout lock management.
 */
interface CheckoutLockManagerInterface {

  /**
   * Acquires a lock for the given order.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The order.
   *
   * @return bool
   *   TRUE if acquired, FALSE if already locked.
   */
  public function acquire(OrderInterface $order): bool;

  /**
   * Releases the lock for the given order.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The order.
   */
  public function release(OrderInterface $order): void;

}
