Commerce Configurable Order Total provides a customizable summary display of
order totals for Drupal Commerce orders. It is designed to be used as a
Views area handler, allowing site builders to control how order totals
are presented.

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/commerce_configurable_order_total).

## Key features & functionalities

- **Customizable Order Total Summary:**

  Displays a summary of the order’s subtotal, adjustments (such as taxes,
  discounts, or fees), and total in a clear, structured format.

- **Views Area Handler:**

  Provides a Views area plugin that can be added to Views to show the
  configurable order total summary, using an Order ID argument.

- **Display Options:**

  The module offers several options to control which parts of the summary
  are shown:

  - **Disable Subtotal:** Hide or show the subtotal line.
  - **Disable Adjustments:** Hide or show all adjustment lines (taxes,
  discounts, etc.).
  - **Disable Totals:** Hide or show the total line.
  - **Strip Trailing Zeroes:** Optionally remove trailing zeroes after
  the decimal point for cleaner price formatting.

- **Themeable Output:**

  The summary is rendered using a Twig template
  `commerce-configurable-order-total-summary.html.twig`, making it easy
  to override and style as needed.

  In your custom theme you can override template by creating folder
  `templates/commerce_configurable_order_total` and copying there
  commerce-configurable-order-total-summary.html.twig file.

## Requirements

Commerce Configurable Order Total module requires Drupal Commerce
module enabled.

## Installation

Install as you would normally install a contributed Drupal module.
For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

Enable the module at Administration > Extend > Commerce.

Edit view "Checkout order summary". In "Footer" section remove "Order total"
and add here "Commerce Configurable Order Total".

## Maintainers

- Piotr Ramotowski - [ramotowski](https://www.drupal.org/u/ramotowski)
