<?php

namespace Drupal\commerce_configurable_order_total\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Defines a module's hooks class.
 */
class Hooks {

  use StringTranslationTrait;

  /**
   * Implements hook_views_data().
   */
  #[Hook('views_data')]
  public function configurableOrderTotalViewsData() {
    $data['views']['commerce_configurable_order_total'] = [
      'title' => $this->t('Commerce Configurable Order Total'),
      'help' => $this->t('Displays the configurable order total field, requires an Order ID argument.'),
      'area' => [
        'id' => 'commerce_configurable_order_total',
      ],
    ];
    return $data;
  }

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function configurableOrderTotalTheme($existing, $type, $theme, $path) {
    return [
      'commerce_configurable_order_total_summary' => [
        'variables' => [
          'order_entity' => NULL,
          'totals' => NULL,
          'disable_subtotal' => NULL,
          'disable_adjustments' => NULL,
          'disable_totals' => NULL,
          'strip_trailing_zeroes' => NULL,
          'description' => NULL,
        ],
      ],
    ];
  }

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function configurableOrderTotalHelp($route_name, $route_parameters) {
    switch ($route_name) {
      case 'help.page.commerce_configurable_order_total':
        $output = '';
        $output .= '<h3>' . $this->t('About') . '</h3>';
        $output .= '<p>' . $this->t('This module provides a customizable summary display of order totals for Drupal Commerce orders. It is designed to be used as a Views area handler, allowing site builders to control how order totals are presented.') . '</p>';
        $output .= '<h3>' . $this->t('Configuration') . '</h3>';
        $output .= '<p>' . $this->t('Edit view "Checkout order summary". In "Footer" section remove "Order total" and add here "Commerce Configurable Order Total".') . '</p>';
        return $output;
    }
  }

}
