<?php

namespace Drupal\commerce_currency_mismatch_prevention\Dto;

/**
 * Data transfer object for currency conflict detection results.
 */
class CurrencyConflictResult {

  /**
   * Constructs a new CurrencyConflictResult.
   *
   * @param bool $hasConflict
   *   Whether a currency conflict was detected.
   * @param string|null $existingCurrency
   *   The existing currency code in the cart (if conflict exists).
   */
  public function __construct(
    protected bool $hasConflict,
    protected ?string $existingCurrency = NULL,
  ) {
  }

  /**
   * Checks if a currency conflict was detected.
   *
   * @return bool
   *   TRUE if conflict exists, FALSE otherwise.
   */
  public function hasConflict(): bool {
    return $this->hasConflict;
  }

  /**
   * Gets the existing currency code.
   *
   * @return string|null
   *   The currency code, or NULL if no conflict or no existing currency.
   */
  public function getExistingCurrency(): ?string {
    return $this->existingCurrency;
  }

}
