# Commerce currency mismatch prevention

This module solves the critical "**The provided prices have mismatched
currencies**" error that occurs in Drupal Commerce when adding products with
different currencies to the same cart.


## Features

Automatically prevents adding products with different currencies to the same
cart, avoiding the ```CurrencyMismatchException``` error. Choose between
behaviors: remove new product, clear cart and add new product.


## Requirements

Commerce Currency Mismatch Prevention module requires Drupal Commerce 3
module enabled.


## Configuration

This module provides a configuration options at
```Commerce > Configuration > Store > Currency mismatch prevention```
where you can set:

- **Remove new product, keep current cart items**: The new product is removed,
and the existing cart items remain unchanged.
- **Remove existing cart items, add new product**: All existing cart items are
removed, and the new product is added to the cart.
- **Disabled**: Allow adding products with different currencies
(may cause errors)


## Usage

When a user attempts to add a product with a different currency than the
existing cart items, the module intervenes based on the configured behavior.


## Installation

Install as you would normally install a contributed Drupal module.
For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Similar modules

- [Commerce Currency Resolver](https://www.drupal.org/project/commerce_currency_resolver) focuses on currency conversion and displaying prices in customer-preferred currencies. Commerce Currency Mismatch Prevention manages cart conflicts without any exchange rate calculations.


## Support

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/commerce_currency_mismatch_prevention).


## Maintainers

- Piotr Ramotowski - [ramotowski](https://www.drupal.org/u/ramotowski)
