<?php

namespace Drupal\commerce_cybersource\Plugin\Commerce\PaymentMethodType;

use Drupal\entity\BundleFieldDefinition;
use Drupal\commerce_payment\CreditCard as CreditCardHelper;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\CreditCard;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;

/**
 * Provides a credit card payment method type for CyberSource's Flex Microform.
 *
 * @CommercePaymentMethodType(
 *   id = "flex_credit_card",
 *   label = @Translation("Credit card"),
 * )
 */
class FlexCreditCard extends CreditCard {

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    // @todo Show a label specific to the transient token when applicable.
    $card_type = CreditCardHelper::getType($payment_method->card_type->value);
    $args = [
      '@card_type' => $card_type->getLabel(),
      '@card_number' => $payment_method->card_number->value,
    ];
    return $this->t('@card_type @card_number', $args);
  }

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['transient_token'] = BundleFieldDefinition::create('string_long')
      ->setLabel(t('Transient token'))
      ->setDescription(t('The full transient token string generated by the Flex Microfrom.'))
      ->setDefaultValue('');

    return $fields;
  }

}
