/**
 * @file
 * Defines behaviors for the CyberSource payer authentication on the review step.
 */

(function (Drupal, once) {
  Drupal.behaviors.commerceCyberSourcePayerAuthentication = {
    attach(context) {
      const checkoutForm = document.querySelector('.commerce-checkout-flow');
      if (!checkoutForm) {
        return;
      }

      // Automatically trigger submit if the form has .flex-autosubmit.
      if (checkoutForm.classList.contains('flex-autosubmit')) {
        checkoutForm.dispatchEvent(
          new Event('submit', { bubbles: true, cancelable: true }),
        );
      }

      // A message is sent by our returnUrl() callback,
      window.addEventListener('message', (event) => {
        if (event.origin !== window.location.origin) {
          console.warn('Untrusted message origin:', event.origin);
          return;
        }

        if (!event.data || event.data.type !== 'cybersource_pa_return') {
          return;
        }

        checkoutForm.dataset.canSubmit = true;
        checkoutForm.submit();
      });

      // Prevent default checkout form submission.
      checkoutForm.addEventListener('submit', function (event) {
        if (!checkoutForm.dataset.canSubmit) {
          event.preventDefault();
          checkoutForm.style.display = 'none';
          const checkoutProgressBlock = document.querySelector(
            '.block-commerce-checkout-progress',
          );
          // Hide the checkout progress block if present.
          if (checkoutProgressBlock) {
            checkoutProgressBlock.style.display = 'none';
          }

          once(
            'cybersource-auto-submit',
            context.querySelectorAll('#cybersource-step-up-form'),
          ).forEach((stepupForm) => {
            stepupForm.submit();
          });
        }
      });
    },
  };
})(Drupal, once);
