# Field Per Commerce Store

This module provides a custom field type that allows to set arbitrary fields per commerce store for commerce product, product variation or any other entity type.

## Example usage

Suppose a product variation might have a feature available for specific stores only, and the feature description can differ between stores. To achieve that, create a new paragraph type and add a feature description text field there. Now add a "Field per store" field to your variation type, and select the new paragraph type as a target entity. You will see a list of checkboxes per store, and when one enabled, the description field will be visible. Check the checkboxes and populate the descriptions as required. When variation is rendered, the value for current store will be displayed.

## Installation and configuration

1. Install the module using composer and enable it.
2. Make sure to create an entity bundle (e.g. paragraph type) to refer to. It should contain all fields you need per store.
3. Add the field to any entity type.
4. Set the field to have unlimited cardinality.
5. Select the target entity type (e.g. paragraphs).
6. Select a single target entity bundle (if more selected, the first one will be used).
7. Configure display and view modes as needed (the field has its own widget and formatter).

## Dependencies

- `entity_reference_revisions`
- `commerce_store`
- `paragraphs`
