<?php

namespace Drupal\commerce_field_per_store\Plugin\LingotekFieldProcessor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\lingotek\Plugin\LingotekFieldProcessor\LingotekEntityReferenceRevisionsProcessor;

/**
 * @LingotekFieldProcessor(
 *   id = "commerce_entity_reference_per_store",
 *   weight = 5,
 * )
 */
class LingotekCommerceFieldPerStoreProcessor extends LingotekEntityReferenceRevisionsProcessor {

  /**
   * {@inheritdoc}
   */
  public function appliesToField(FieldDefinitionInterface $field_definition, ContentEntityInterface &$entity) {
    return 'commerce_entity_reference_per_store' === $field_definition->getType();
  }

}
