<?php

namespace Drupal\commerce_field_per_store\Plugin\RelatedEntitiesDetector;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\lingotek\Plugin\RelatedEntitiesDetector\EntityReferenceDetectorBase;
use Drupal\lingotek\RelatedEntities\RelatedEntitiesDetectorInterface;

/**
 * @RelatedEntitiesDetector (
 *   id = "nested_commerce_entity_reference_per_store_detector",
 *   title = @Translation("Get related commerce fields per store"),
 *   description = @translation("The default retrieval of nested commerce fields per store"),
 *   weight = 6,
 * )
 */
class NestedCommerceFieldPerStoreDetector extends EntityReferenceDetectorBase implements RelatedEntitiesDetectorInterface, ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  protected $fieldTypes = ["commerce_entity_reference_per_store"];

}
