<?php

namespace Drupal\commerce_fincra\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OffsitePaymentGatewayInterface;

/**
 * Provides the interface for the Fincra payment.
 */
interface FincraStandardInterface extends OffsitePaymentGatewayInterface {

  /**
   * Get the Fincra API Secret key set for the payment gateway.
   *
   * @return string
   *   The Fincra API Secret key.
   */
  public function getSecretKey();

  /**
   * Get the Fincra API Public key set for the payment gateway.
   *
   * @return string
   *   The Fincra API Public key.
   */
  public function getPublicKey();

  /**
   * Get unique identifier for a business within the Fincra platform.
   *
   * @return string
   *   The Fincra Business Id.
   */
  public function getBusinessId();

  /**
   * Get the Webhook/Encryption key for the payment gateway.
   *
   * @return string
   *   The Webhook/Encryption key.
   */
  public function getWebhookKey();

  /**
   * Returns a mapping of Fincra payment statuses to payment states.
   *
   * @param $status
   *   (optional) The Fincra payment status.
   *
   * @return array|string
   *   An array containing the Fincra remote statuses as well as their
   *   corresponding states. if $status is specified, the corresponding state
   *   is returned.
   */
  public function getStatusMapping($status = NULL);
  
}
