<?php

namespace Drupal\commerce_fincra\Service;

use Drupal\commerce_fincra\Plugin\Commerce\PaymentGateway\FincraStandardInterface;

/**
 * Provides the interface for the Fincra Checkout Redirect Service.
 */
interface FincraCheckoutRedirectServiceInterface {

  /**
   * Get the API base URL depending on mode.
   *
   * @param string $mode
   *   The mode: 'test' or 'live'.
   *
   * @return string
   *   The base API URL.
   */
  public function getBaseUrl(string $mode): string;

  /**
   * Send checkout request to Fincra.
   *
   * @param array $params
   *   Data for creating the checkout.
   *
   * @param \Drupal\commerce_fincra\Plugin\Commerce\PaymentGateway\FincraStandardInterface $gateway
   *   The payment gateway entity (to fetch keys from config).
   *
   * @return array|null
   *   The checkout redirect body or NULL if failed.
   */
  public function createCheckoutRedirect(array $params, FincraStandardInterface $gateway);

  /**
   * Verify the status of the transaction on the checkout API.
   *
   * @param string $reference
   *  The unique reference for the transaction.
   *
   * @param \Drupal\commerce_fincra\Plugin\Commerce\PaymentGateway\FincraStandardInterface $gateway
   *   The payment gateway entity (to fetch keys from config).
   */
  public function verifyTransaction($reference, FincraStandardInterface $gateway);

}
