<?php

namespace Drupal\commerce_funds;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\commerce_funds\Entity\TransactionType;

/**
 * Defines a default implementation for entity access control handler.
 */
class TransactionBundleAccessControlHandler extends EntityAccessControlHandler {

  /**
   * Performs access checks.
   *
   * This method override the default AccessControlHandler to give
   * access to all users to transaction bundles on view operation.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity for which to check access.
   * @param string $operation
   *   The entity operation. Usually one of 'view', 'view label', 'update' or
   *   'delete'.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user for which to check access.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result as neutral.
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    if ($operation == 'view' && $entity instanceof TransactionType) {
      return AccessResult::allowed();
    }

    return AccessResult::forbidden();
  }

}
