# Commerce HyperPay

## CONTENTS OF THIS FILE

- Introduction
- Requirements
- Installation
- Configuration
- How it works
- Maintainers

## INTRODUCTION

**Commerce HyperPay** is [Drupal Commerce](https://drupal.org/project/commerce)
module that integrates the [hyperpay.com](https://www.hyperpay.com/) payement
gateway into your Drupal Commerce shop.

## REQUIREMENTS

This module requires the following:

- Submodules of Drupal Commerce package (https://drupal.org/project/commerce)
  - Commerce core
  - Commerce Payment (and its dependencies)
- Hyperpay.com merchant account (test or live) (https://www.hyperpay.com/)

## INSTALLATION

Open your terminal and download with composer.
composer require drupal/commerce_hyperpay

OR

1. Download the module to your DRUPAL_ROOT/modules directory,
   or where ever you install contrib modules on your site.
2. Go to Admin > Extend and enable the module.

## CONFIGURATION

- Create a new Hyperpay COPYandPAY payment gateway.
  Administration > Commerce > Configuration > Payment gateways > Add payment gateway
  Hyperpay COPYandPAY specific settings available:
  - Test Mode Type
  - Server
  - Allowed Cards
  - Authorization Bearer
  - Entity ID
  - Allow reusing payment method
  - Entity ID (Recurring - no 3D Secure), in case Allow reusing payment method is enabled
  - Widget Style (to select the needed stlye)
    You will get all these settings from HyperPay.

## HOW IT WORKS

- CopyAndPay
  CopyAndPay payment is an Iframe embeded on the checkout page.

- 3DS support:
  Handled by the HyperPay CopyAndPay Iframe.

- Checkout workflow:
  It follows the Drupal Commerce Credit Card workflow.
  The customer should enter his/her credit card data
  or select one of the credit cards saved with HyperPay.com
  from a previous order.

- Payment Terminal
  The store owner can Void, Capture and Refund the HyperPay.com payments.

## MAINTAINERS

- Anas Mawlawi (Anas_maw) - <https://www.drupal.org/u/anas_maw>
- Yasser Samman (yasser-samman) - https://www.drupal.org/u/yasser-samman

This project has been developed by:

- Coders Enterprise Web & Mobile Solutions: https://www.codersme.com/
